//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Threading;

namespace ProfilingSamples
{
	public class ContentionMain 
	{
		static Random r;
		private void WorkerThread()
		{
			Monitor.Enter(this);
			Thread.Sleep(r.Next(1000));
			Monitor.Exit(this);
		}
		private void TestThread()
		{
			try
			{
				while(true)
				{ 
					Thread [] t = new Thread[10];
					for(int i = 0;i < 10;i++)
					{
						t[i] = new Thread(new ThreadStart(WorkerThread));
						t[i].Start();
					}
					for(int i = 0;i < 10;i++)
					{
						t[i].Join();
					}
					Thread.Sleep(5000);
				}
			}
			catch(Exception e)
			{
				Console.WriteLine("TestThread przerywa prac: {0}", e.Message);
			}
		}
		static void Main(string [] args)
		{
			r = new Random();
			ContentionMain m = new ContentionMain();
			Thread testThread = new Thread(new ThreadStart(m.TestThread));
			testThread.Start();
			string input = Console.ReadLine();
			testThread.Abort();
			testThread.Join();
		}
	}
}